package gov.va.med.mhv.integration.phr.dao;

import gov.va.med.mhv.integration.phr.stage.transfer.StageAppointment;
import gov.va.med.mhv.integration.phr.stage.transfer.StageEntityAK;
import gov.va.med.mhv.integration.phr.stage.transfer.StagePathwaysAppointment;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public interface PhrAppointmentDAO  extends PhrBaseDAO {

	void insertPHRAppointment(StageAppointment record);

	int loadPHRAppointment(StageEntityAK ak, String stationNumber, List<StageAppointment> records) throws SQLException;

	long deletePHRAppointment(String icn, String stationNumber) throws SQLException;
	
	void processPHRAppointmentReminder(StageEntityAK ak, boolean refreshed) throws SQLException;

	void findStationNumberNamesByStationNumber(Map<String, String> locationByStationNumber) throws SQLException;

	// NEW
	public void insertPHRAppointment(StageAppointment record, String icn, Long facilityInfoId, Long phrFacilityControlId);
	// NEW
	boolean replaceOnePHRAppointment(StagePathwaysAppointment record) throws SQLException;
	// NEW
	long deleteOnePHRAppointment(StagePathwaysAppointment record, Long facilityInfoId, Long phrFacilityControlId) throws SQLException;

}
